/*
 * Generic PWM backlight driver data - see drivers/video/backlight/pwm_bl.c
 */
#ifndef __LINUX_PWM_BACKLIGHT_H
#define __LINUX_PWM_BACKLIGHT_H

struct platform_pwm_backlight_data {
	int pwm_id;
	unsigned int max_brightness;
	unsigned int invert_brightness;
	unsigned int dft_brightness;
	unsigned int pwm_period_ns;
	unsigned int color_depth;
	unsigned int pixel_height;
    unsigned int pixel_width;
    unsigned int mm_height;
    unsigned int mm_width;

	int (*init)(struct device *dev);
	int (*notify)(struct device *dev, int brightness);
	void (*exit)(struct device *dev);
};

#endif
